var GOOGLETABS = {
	resultURLs : [],
	
	currentURL : "",
	
	enableGoogleTabs : function (event) {
		if (!window.content){
			setTimeout('GOOGLETABS.enableGoogleTabs()',1000);
		}
		else {
			var url = window.content.location.href;
			
			if (url == this.currentURL){
				return;
			}
			else {
				this.resultURLs = new Array();
				this.currentURL = url;

				if (url.match(/^http:\/\/www\.google\.[a-z\.]+\/search\?/i)) {
					this.addGoogleTabs("Open Search Results in Tabs");
					
					var results = window.content.document.evaluate("//a[@class='l']", window.content.document, null, XPathResult.ORDERED_NODE_ITERATOR_TYPE, null);
					
					var thisResult = results.iterateNext();
					
					while (thisResult){
						this.resultURLs.push(thisResult.getAttribute("href"));
						thisResult = results.iterateNext();
					}
				}
				else if (url.match(/^http:\/\/scholar\.google\.[a-z\.]+\/scholar\?/i)) {
					this.addGoogleTabs("Open Scholar Search Results in Tabs");
					
					var linkURL = url.substr(0, url.indexOf("/scholar?"));
					
					var results = window.content.document.evaluate("//p[@class='g']/span[@class='w']/a", window.content.document, null, XPathResult.ORDERED_NODE_ITERATOR_TYPE, null);
					
					var thisResult = results.iterateNext();
					
					while (thisResult){
						this.resultURLs.push(linkURL + thisResult.getAttribute("href"));
						thisResult = results.iterateNext();
					}
				}
				else if (url.match(/^http:\/\/news\.google\.[a-z\.]+\/news\?/i)) {
					this.addGoogleTabs("Open News Search Results in Tabs");
					
					var results = window.content.document.evaluate("//table[@width='75%']/tbody/tr/td/a[@id and count(img)=0]", window.content.document, null, XPathResult.ORDERED_NODE_ITERATOR_TYPE, null);
					
					var thisResult = results.iterateNext();
					
					while (thisResult){
						this.resultURLs.push(thisResult.getAttribute("href"));
						thisResult = results.iterateNext();
					}
				}
				else if (url.match(/^http:\/\/news\.google\.[a-z\.]+\//i)) {
					this.addGoogleTabs("Open All News Stories in Tabs");
					
					var results = window.content.document.evaluate("//td[@width='49%']/table/tbody/tr/td/div/table/tbody/tr/td/a", window.content.document, null, XPathResult.ORDERED_NODE_ITERATOR_TYPE, null);
					
					var thisResult = results.iterateNext();
					
					while (thisResult){
						this.resultURLs.push(thisResult.getAttribute("href"));
						thisResult = results.iterateNext();
					}
				}
				else if (url.match(/^http:\/\/images\.google\.[a-z\.]+\/images\?/i)) {
					this.addGoogleTabs("Open Image Search Results in Tabs");
					
					var results = window.content.document.evaluate("//div[@id='ImgContent']//a[img]", window.content.document, null, XPathResult.ORDERED_NODE_ITERATOR_TYPE, null);
					var linkRoot = url.substr(0, url.indexOf("/images?"));
					var thisResult = results.iterateNext();
					
					while (thisResult){
						if (thisResult.getAttribute("href").indexOf("/") == 0){
							var link = linkRoot + thisResult.getAttribute("href");
						}
						else {
							var link = thisResult.getAttribute("href");
						}
						
						if (!this.arrayContains(this.resultURLs, link)){
							this.resultURLs.push(link);
						}
						
						thisResult = results.iterateNext();
					}
				}
				else if (url.match(/^http:\/\/froogle\.google\.[a-z\.]+\/froogle\?/i)) {
					this.addGoogleTabs("Open Froogle Search Results in Tabs");
					
					var linkURL = url.substr(0, url.indexOf("/froogle?"));
					
					var results = window.content.document.evaluate("//table[@class='list']/tbody/tr/td/a", window.content.document, null, XPathResult.ORDERED_NODE_ITERATOR_TYPE, null);
					
					var thisResult = results.iterateNext();
					
					while (thisResult){
						var link = linkURL + thisResult.getAttribute("href")
						
						if (!this.arrayContains(this.resultURLs, link)){
							this.resultURLs.push(linkURL + thisResult.getAttribute("href"));
						}
						
						thisResult = results.iterateNext();
					}
				}
				else if (url.match(/^http:\/\/groups\.google\.[a-z\.]+\/groups\/search\?/i)) {
					this.addGoogleTabs("Open Group Search Results in Tabs");
					
					var linkURL = url.substr(0, url.indexOf("/groups/"));
					
					var results = window.content.document.evaluate("//div[@id='cbdy']/div/font/a[b]", window.content.document, null, XPathResult.ORDERED_NODE_ITERATOR_TYPE, null);
					
					var thisResult = results.iterateNext();
					
					while (thisResult){
						var link = linkURL + thisResult.getAttribute("href");
						
						if (!this.arrayContains(this.resultURLs, link)){
							this.resultURLs.push(linkURL + thisResult.getAttribute("href"));
						}
						
						thisResult = results.iterateNext();
					}
				}
				else if (url.match(/^http:\/\/groups\.google\.[a-z\.]+\/groups\?q/i)) {
					this.addGoogleTabs("Open Group Search Results in Tabs");
					
					var linkURL = url.substr(0, url.indexOf("/groups?"));
					
					var results = window.content.document.evaluate("//div[@id='cbdy']/div/font/a[b]", window.content.document, null, XPathResult.ORDERED_NODE_ITERATOR_TYPE, null);
					
					var thisResult = results.iterateNext();
					
					while (thisResult){
						var link = linkURL + thisResult.getAttribute("href");
						
						if (!this.arrayContains(this.resultURLs, link)){
							this.resultURLs.push(linkURL + thisResult.getAttribute("href"));
						}
						
						thisResult = results.iterateNext();
					}
				}
				else if (url.match(/^http:\/\/groups\.google\.[a-z\.]+\/group\//i)) {
					this.addGoogleTabs("Open All Group Topics in Tabs");
					
					var linkURL = url.substr(0, url.indexOf("/group/"));
					
					var results;
					
					if (url.indexOf("gvc=1") != -1){
						results = window.content.document.evaluate("//div[@id='cbdy']/div/p//a[font]", window.content.document, null, XPathResult.ORDERED_NODE_ITERATOR_TYPE, null);
					}
					else {
						results = window.content.document.evaluate("//div[@id='cbdy']/div/table[@cellpadding='3']/tbody/tr[position()>2]/td[2]/a", window.content.document, null, XPathResult.ORDERED_NODE_ITERATOR_TYPE, null);
					}
					
					var thisResult = results.iterateNext();
					
					while (thisResult){
						var link = linkURL + thisResult.getAttribute("href");
						
						if (!this.arrayContains(this.resultURLs, link)){
							this.resultURLs.push(linkURL + thisResult.getAttribute("href"));
						}
						
						thisResult = results.iterateNext();
					}
				}
				else if (url.match(/^http:\/\/maps\.google\.[a-z\.]+\/maps\?/i)) {
					this.addGoogleTabs("Open Local Search Results in Tabs");
					
					var linkURL = url.substr(0, url.indexOf("/maps?"));
					
					var results = window.content.document.evaluate("//div[@id='panel']/div[@class='local']/div[@class='noprint']/table[@class='res']/tbody/tr/td[2]/div[@class='name']/a[@onclick]", window.content.document, null, XPathResult.ORDERED_NODE_ITERATOR_TYPE, null);
					
					var thisResult = results.iterateNext();
					
					while (thisResult){
						var link = linkURL + thisResult.getAttribute("href");
						
						if (!this.arrayContains(this.resultURLs, link)){
							this.resultURLs.push(linkURL + thisResult.getAttribute("href"));
						}
						
						thisResult = results.iterateNext();
					}
				}
				else if (url.match(/^http:\/\/local\.google\.[a-z\.]+\/local\?/i)) {
					this.addGoogleTabs("Open Local Search Results in Tabs");
					
					var linkURL = url.substr(0, url.indexOf("/local?"));
					
					var results = window.content.document.evaluate("//div[@id='panel']/div[@class='local']/div[@class='noprint']/table[@class='res']/tbody/tr/td[2]/div[@class='name']/a[@onclick]", window.content.document, null, XPathResult.ORDERED_NODE_ITERATOR_TYPE, null);
					
					var thisResult = results.iterateNext();
					
					while (thisResult){
						var link = linkURL + thisResult.getAttribute("href");
						
						if (!this.arrayContains(this.resultURLs, link)){
							this.resultURLs.push(linkURL + thisResult.getAttribute("href"));
						}
						
						thisResult = results.iterateNext();
					}
				}
				else {
					this.removeGoogleTabs();
				}
			}
		}
	},
	
	googleTabs : function (event){
		for (var i = 0; i < this.resultURLs.length; i++){
			gBrowser.addTab(this.resultURLs[i]);
		}	

		return true;
	},
	
	addGoogleTabs : function(label){
		var menu = document.getElementById('contentAreaContextMenu');
		
		var existingOption = document.getElementById('googleTabsOption');
		
		if (!existingOption){
			var option = document.createElement('menuitem');
			option.setAttribute("id","googleTabsOption");
			option.setAttribute("command","googleTabs");
			option.setAttribute("accesskey","T");
			
			menu.insertBefore(option, document.getElementById("context-stop").nextSibling);
		}

		document.getElementById('googleTabs').setAttribute("label",label);
	},
	
	removeGoogleTabs : function(){
		var option = document.getElementById('googleTabsOption');
		
		if (option){
			document.getElementById('contentAreaContextMenu').removeChild(option);
		}
	},
	
	arrayContains : function (arr, val){
		var i;
			
		for (i = 0; i < arr.length; i++) {
			if (arr[i] === val) {
				return true;
			}
		}
			
		return false;
	}
}
